--[[---------------------------------------------------------------------------
	Chocolatier Two Simulator: Utility functions
	Copyright (c) 2006-2007 Big Splash Games, LLC. All Rights Reserved.
--]]---------------------------------------------------------------------------

-------------------------------------------------------------------------------
-- Data helpers

function bsgArrayIterator(t)
	local i = 0
	local n = table.getn(t)
	return function()
		i = i + 1
		return (i <= n) and t[i] or nil
	end
end

-------------------------------------------------------------------------------
-- Font info

function bsgFontHeight(f)
	return f[2]
end

-------------------------------------------------------------------------------
-- Development helpers

function bsgDevWarning(message)
	DebugOut(message)
	if gSim then gSim:Message(message) end
	DisplayDialog { "ui/okdialog.lua", body="#"..message }
end
